import models from '../../models/index.js';
const { Agendamiento, FichaAprendiz, Ficha } = models;
import ApiResponse from '../../utils/apiResponse.js';
import { transformarAgendamiento } from '../../utils/agendamientos.js';

//Modificar un agendamiento por ID
export const updateAgendamiento = async (req, res) => {
  const { idAgendamiento } = req.params;

  try {
    const [updateRow] = await Agendamiento.update(req.body, {
      where: {
        idAgendamiento: idAgendamiento,
      },
    });

    if (updateRow === 0) {
      return ApiResponse.notFound(
        res,
        'Agendamiento no encontrado o se modifico.'
      );
    }

    const agendamientoActualizado = await Agendamiento.findByPk(
      idAgendamiento,
      {
        include: [
          {
            model: FichaAprendiz,
            attributes: ['idFichaAprendiz'],
            include: [
              {
                model: Ficha,
                attributes: ['idFicha'],
              },
            ],
          },
        ],
      }
    );

    //Transformar para limpiar y agregar idFicha directamente
    const agendamientoTransformado = transformarAgendamiento(
      agendamientoActualizado
    );

    return ApiResponse.success(
      res,
      agendamientoTransformado,
      'Agendamiento actualizado exitosamente.'
    );
  } catch (error) {
    console.error(
      'Error en la actualización de los datos del Agendamiento:',
      error
    );
    return ApiResponse.error(
      res,
      error,
      'Error en la actualizacion de los datos del Agendamiento.'
    );
  }
};
